## Video Streaming Server with Node.js and Koa

Widely used on the Internet and on mobile networks, video streaming allows to play video streams without having to download them. When working with large amount of data, streams allow to send data chunk by chunk from a source to a destination in a particular order.

The purpose of this project is to set up a video streaming server that serves videos hosted on a server without having to download the entire video file. The end user can move on different positions of the video without having to download the entire file.

Once you understand how to set up the video streaming server, you can create the server in any platform you like such as ASP.NET Core, Ruby on Rails, PHP, and so on.

The video streaming server is available at: http://localhost:3000

## .env

Below is the default `.env` file:
```
PORT=3000
```

You can change the streaming server port from `PORT` environment variable.

## Videos
Before to run the server, you need to create *videos* folder and add a video in:
```
./videos/video.mp4
```

If you want to change the video, just update `src` attribute of `<video>` element in *public/index.html*.

## Supported Formats
Here are the supported formats:
* Theora (Ogg)
* H.264 (MP4)
* HEVC/H.265 (MP4)
* VP8 (WebM)
* VP9 (WebM)
* AV1 (WebM)
* Matroska (MKV)

Opus audio codec is also supported. This applies to mp4, ogg, and webm containers. AAC audio codec is supported as well.

## Subtitles
It is possible to add subtitles through `<track>` element in `<video>` element in `public/index.html` as follows:
```html
<video 
    src="http://localhost:3000/api/video/video.mp4"
    playsInline
    muted
    autoplay
    controls 
    controlsList="nodownload"
  >
  <track
    label="English"
    kind="subtitles"
    srclang="en"
    src="captions/vtt/video-en.vtt"
    default />
  <track
    label="Deutsch"
    kind="subtitles"
    srclang="de"
    src="captions/vtt/video-de.vtt" />
</video>
```
The files that contain subtitles data are simple text files that follow the [Web Video Text Tracks](https://developer.mozilla.org/en-US/docs/Web/API/WebVTT_API) (WebVTT) format.

## Run
```
npm install
npm start
```

## Dev
```
npm install
npm run dev
```

# 
You can find out more about this project on this [CodeProject](https://www.codeproject.com/Articles/5350209/Video-Streaming-with-Node-js-and-Koa) article.
