/*
 * Copyright (c) 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.tyrus.tests.servlet.embedded;

import jakarta.websocket.Decoder;
import jakarta.websocket.Encoder;
import jakarta.websocket.Endpoint;
import jakarta.websocket.Extension;
import jakarta.websocket.server.ServerEndpointConfig;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DispatchingServletProgrammaticEndpointConfig implements ServerEndpointConfig {

    private final Class<? extends Endpoint> endpointClass;
    private final String path;

    public DispatchingServletProgrammaticEndpointConfig(Class<? extends Endpoint> endpointClass, String path) {
        this.endpointClass = endpointClass;
        this.path = path;
    }

    @Override
    public Class<?> getEndpointClass() {
        return endpointClass;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public List<String> getSubprotocols() {
        return Collections.emptyList();
    }

    @Override
    public List<Extension> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    public Configurator getConfigurator() {
        return new ProgrammaticEndpointConfigurator();
    }

    @Override
    public List<Class<? extends Encoder>> getEncoders() {
        return Collections.emptyList();
    }

    @Override
    public List<Class<? extends Decoder>> getDecoders() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return Collections.emptyMap();
    }

    /*
     * Anonymous classes do not work with Arquillian archive and module-info.
     */
    static class ProgrammaticEndpointConfigurator extends Configurator {
        @Override
        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (DispatchingServletFilter.ProgramaticEndpoint.class.equals(endpointClass)) {
                return (T) new DispatchingServletFilter.ProgramaticEndpoint();
            }
            return super.getEndpointInstance(endpointClass);
        }
    }
}
