package com.coltware.springboot.main;

import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class SampleApplication {

    private static final Logger log = LoggerFactory.getLogger(SampleApplication.class);

    @Autowired
    Gson gson;

    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(SampleApplication.class,args);
        SampleApplication app = context.getBean(SampleApplication.class);
        app.start(context);
    }

    public void start(ApplicationContext context){
        log.info("gson : {} - {} ", AopUtils.isAopProxy(gson),System.identityHashCode(gson));
        String beans[] = context.getBeanDefinitionNames();
        for(int i = 0; i < beans.length; i++){
            log.info("bean name : {}",beans[i]);
        }

    }
}
