package com.coltware.springboot.autoconfigure.h2;

import org.h2.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

@EnableConfigurationProperties(H2Properties.class)
@ConditionalOnClass(Driver.class)
@Configuration(proxyBeanMethods = false)
public class H2AutoConfiguration {

    @Autowired H2Properties h2Properties;

    @Bean
    @ConditionalOnProperty("h2.url")
    @ConditionalOnMissingBean(Connection.class)
    public Connection connection() throws SQLException {
        Connection conn = DriverManager.getConnection(h2Properties.getUrl());
        return conn;
    }

    @Bean
    @ConditionalOnMissingBean(Connection.class)
    public Connection defaultConnection() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:default");
        return conn;
    }
}
