package com.coltware.springboot.autoconfigure.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods = true)
@ConditionalOnMissingClass
public class GsonCustomConfiguration {
    @Bean
    public GsonBuilder gsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        return builder;
    }

    @Bean
    public Gson gson(GsonBuilder gsonBuilder) {
        Gson gson = gsonBuilder.create();
        return gson;
    }
}
