package com.coltware.springboot.zipcode.task;

import org.apache.camel.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Component
public class WebDownloadTask {

    private static final Logger log = LoggerFactory.getLogger(WebDownloadTask.class);

    @Autowired
    CamelContext camelContext;

    @Value("${zipcode.download.url}")
    private String downloadUrl;

    @Value("${zipcode.download.cron}")
    private String cronSchedule;

    @Scheduled(cron = "${zipcode.download.cron}")
    public void downloadFile(){

        log.info("download cron :{}",cronSchedule);

        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder(URI.create(downloadUrl)).build();

        try {
            Path path = Files.createTempFile("download-",".zip");

            HttpResponse<Path> response = client.send(request, HttpResponse.BodyHandlers.ofFile(path));
            File file = path.toFile();
            if(file.exists()){

                ZipFile zipFile = new ZipFile(file);
                ZipEntry entry = zipFile.entries().nextElement();
                log.info("zip file is : {}",entry.getName());

                InputStream is = zipFile.getInputStream(entry);
                ProducerTemplate template = camelContext.createProducerTemplate();
                Exchange exchange = template.send("direct:import", new Processor() {
                    @Override
                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody(is,InputStream.class);
                    }
                });

                Message out = exchange.getOut();
                String status = out.getHeader("status",String.class);
                if(status.equals("OK")){
                    log.info("import OK");
                }
                else{
                    log.warn("import error : {}",out.getBody(Exception.class).getMessage());
                }

                file.delete();

            }
        }
        catch(Exception ex){
            log.error(ex.getMessage(),ex);
        }

    }
}
