package com.coltware.springboot.zipcode.controller;

import com.coltware.springboot.zipcode.data.model.ZipCode;
import com.coltware.springboot.zipcode.data.repository.ZipCodeRepository;
import com.coltware.springboot.zipcode.response.NotFoundItemException;
import com.coltware.springboot.zipcode.response.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.ValidationException;

@RestController
@RequestMapping("/zipcode")
public class ZipCodeController {

    private static final Logger log = LoggerFactory.getLogger(ZipCodeController.class);

    @Autowired
    ZipCodeRepository zipcodeRepository;

    /**
     * @param code
     * @return
     */
    @GetMapping("/find/{code}")
    public Response findAction(@PathVariable("code") String code) {

        if( StringUtils.isBlank(code) || !StringUtils.isNumeric(code) ){
            throw new ValidationException("path variable code error");
        }

        ZipCode item = zipcodeRepository.findFirstByUid(code);
        if( item == null ){
            throw new NotFoundItemException("not found : code = " + code);
        }

        return Response.createSuccessResponse(new ZipCodeResponse(code,item.getAddress()));
    }

    /**
     *   レスポンスデータ
     */
    public class ZipCodeResponse {

        private String zipcode;
        private String address;

        public ZipCodeResponse(String zipcode, String address) {
            this.zipcode = zipcode;
            this.address = address;
        }

        public String getZipcode() {
            return zipcode;
        }

        public String getAddress() {
            return address;
        }
    }
}
