package com.coltware.springboot.zipcode.config;

import com.coltware.springboot.zipcode.response.ErrorResponse;
import com.coltware.springboot.zipcode.response.Response;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Configuration
@EnableWebSecurity
@Order(1)
public class WebHeaderSecurityConfiguration extends WebSecurityConfigurerAdapter {

    private static final Logger log = LoggerFactory.getLogger(WebHeaderSecurityConfiguration.class);

    public class HeaderCheckFilter extends AbstractPreAuthenticatedProcessingFilter {

        private String headerName;

        public HeaderCheckFilter(String headerName) {
            this.headerName = headerName;
        }

        @Override
        protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
            return request.getHeader(headerName);
        }

        @Override
        protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
            return "";
        }
    }

    @Override
    protected void configure(HttpSecurity http) throws Exception {

        HeaderCheckFilter filter = new HeaderCheckFilter("X-Token");

        filter.setAuthenticationManager(new AuthenticationManager() {
            @Override
            public Authentication authenticate(Authentication authentication) throws AuthenticationException {

                String principal = (String) authentication.getPrincipal();

                // X-Token の値をチェックする

                if(principal.equals("PASS")) {
                    authentication.setAuthenticated(true);
                }
                else{
                    log.info("===== value error ======");
                    throw new BadCredentialsException("Token key error");
                }
                return authentication;
            }
        });

        http.antMatcher("/admin/**");

        http.addFilter(filter);
        http.authorizeRequests()
                .anyRequest()
                .authenticated();

        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);

        http.csrf().disable();

        http.exceptionHandling().authenticationEntryPoint(new ErrorAuthEntryPoint());
    }



    public class ErrorAuthEntryPoint implements AuthenticationEntryPoint {

        @Override
        public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException)
                throws IOException, ServletException {

            ErrorResponse errorResponse = Response.createErrorResponse(authException);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS,true);

            response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.setCharacterEncoding("UTF-8");

            mapper.writeValue(response.getWriter(),errorResponse);
        }
    }
}
