package com.coltware.springboot.zipcode;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.servlet.DispatcherServlet;

@SpringBootApplication
@EnableScheduling
public class MainApplication {

    private static final Logger log = LoggerFactory.getLogger(MainApplication.class);

    public static void main(String[] args) {

        SpringApplication app = new SpringApplication(MainApplication.class);
        app.addListeners(new ApplicationListener<ApplicationEvent>() {
            @Override
            public void onApplicationEvent(ApplicationEvent event) {
                log.info("===== event ===== {}", event.getClass());
            }
        });
        app.addListeners(new ApplicationListener<ServletWebServerInitializedEvent>() {
            @Override
            public void onApplicationEvent(ServletWebServerInitializedEvent event) {
                log.info("servlet init end" , event.getApplicationContext());
                ServletWebServerApplicationContext context = event.getApplicationContext();

                DispatcherServlet servlet = (DispatcherServlet)event.getApplicationContext().getBean(ServletWebServerApplicationContext.DISPATCHER_SERVLET_NAME);
                servlet.setThrowExceptionIfNoHandlerFound(true);
            }
        });
        app.run(args);
    }
}

