package com.coltware.springboot.zipcode.data.model;

import javax.persistence.*;

@Entity
@Table(name = "zipcode")
public class ZipCode {


    @Id
    @GeneratedValue
    private Integer id;

    @Column(nullable =  false)
    private String uid;

    @Column(name = "pref" , nullable = false)
    private String pref;

    @Column(name = "city" , nullable = false)
    private String city;

    @Column(name = "town" , nullable = false)
    private String town;

    public ZipCode() {
    }

    public ZipCode(String uid, String pref, String city, String town) {
        this.uid = uid;
        this.pref = pref;
        this.city = city;
        this.town = town;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getUid() {
        return uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getPref() {
        return pref;
    }

    public void setPref(String pref) {
        this.pref = pref;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTown() {
        return town;
    }

    public void setTown(String town) {
        this.town = town;
    }

    public String getAddress(){
        return pref + city + town;
    }
}
