package com.coltware.springboot.zipcode.controller;

import com.coltware.springboot.zipcode.response.NotFoundItemException;
import com.coltware.springboot.zipcode.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;

/**
 * Created by kobayashi on 2019-02-16.
 */
@RestControllerAdvice
public class ErrorController {

    private static final Logger log = LoggerFactory.getLogger(ErrorController.class);

    /**
     *
     * @param req
     * @param ex
     * @return
     */
    @ExceptionHandler(ValidationException.class)
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    public Response handleValidationException(HttpServletRequest req, ValidationException ex){
        return Response.createErrorResponse(ex);
    }

    /**
     * 見つからなかった場合のエラー
     * @param request
     * @param ex
     * @return
     */
    @ExceptionHandler(NotFoundItemException.class)
    @ResponseStatus(HttpStatus.NOT_FOUND)
    public Response handleNotFoundItemException(HttpServletRequest request, NotFoundItemException ex){
        return Response.createErrorResponse(ex);
    }

    /**
     * 許可されないメソッドの実行
     * @param request
     * @param ex
     * @return
     */
    @ExceptionHandler(HttpRequestMethodNotSupportedException.class)
    @ResponseStatus(HttpStatus.FORBIDDEN)
    public Response handleMethodNotSupportedException(HttpServletRequest request, HttpRequestMethodNotSupportedException ex){
        return Response.createErrorResponse(ex);
    }

    /**
     * 上記で処理していないエラー
     *
     * @param request
     * @param ex
     * @return
     */
    @ExceptionHandler(Exception.class)
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    public Response handleException(HttpServletRequest request, Exception ex){
        log.error(ex.getMessage(),ex);
        return Response.createErrorResponse(ex);
    }
}
