package com.coltware.springboot.zipcode.controller;

import com.coltware.springboot.zipcode.data.model.ZipCode;
import com.coltware.springboot.zipcode.data.repository.ZipCodeRepository;
import com.coltware.springboot.zipcode.response.NotFoundItemException;
import com.coltware.springboot.zipcode.response.Response;
import org.apache.camel.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.ValidationException;
import java.io.InputStream;

@RestController
@RequestMapping("/admin/zipcode")
public class AdminController {

    private static final Logger log = LoggerFactory.getLogger(AdminController.class);

    @Autowired
    ZipCodeRepository zipcodeRepository;

    @Autowired
    CamelContext camelContext;

    /**
     * @param code
     * @return
     */
    @GetMapping("/find/{code}")
    public Response findAction(@PathVariable("code") String code) {

        if( StringUtils.isBlank(code) || !StringUtils.isNumeric(code) ){
            throw new ValidationException("path variable code error");
        }

        ZipCode item = zipcodeRepository.findFirstByUid(code);
        if( item == null ){
            throw new NotFoundItemException("not found : code = " + code);
        }
        return Response.createSuccessResponse(new ZipCodeResponse(code,item.getAddress()));
    }

    /**
     * データを設定する
     * @param item
     * @return
     */
    @PostMapping("/set")
    public ZipCode setAction(@RequestBody ZipCode item){
        String code = item.getUid();

        if(StringUtils.isBlank(code) || !StringUtils.isNumeric(code)){
            throw new ValidationException("path variable code error");
        }

        ZipCode found = zipcodeRepository.findFirstByUid(code);
        if ( found != null ) {
            item.setId(found.getId());
        }
        zipcodeRepository.save(item);
        return item;
    }

    @PutMapping("/import")
    public Response importAction(InputStream is){

        ProducerTemplate template = camelContext.createProducerTemplate();
        Exchange exchange = template.send("direct:import", new Processor() {
            @Override
            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody(is,InputStream.class);
            }
        });

        Message out = exchange.getOut();
        String status = out.getHeader("status",String.class);
        if(status.equals("OK")){
            return Response.createSuccessResponse(null);
        }
        else{
            return Response.createErrorResponse(out.getBody(Exception.class));
        }
    }

    /**
     *   レスポンスデータ
     */
    public class ZipCodeResponse {

        private String zipcode;
        private String address;

        public ZipCodeResponse(String zipcode, String address) {
            this.zipcode = zipcode;
            this.address = address;
        }

        public String getZipcode() {
            return zipcode;
        }

        public String getAddress() {
            return address;
        }
    }
}
