package com.coltware.springboot.zipcode.config;

import com.coltware.springboot.zipcode.response.ErrorResponse;
import com.coltware.springboot.zipcode.response.Response;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Configuration
@EnableWebSecurity
public class WebSecurityConfiguration extends WebSecurityConfigurerAdapter {


    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfigurerAdapter.class);

    @Value("${zipcode.admin.username}")
    private String username;

    @Value("${zipcode.admin.password")
    private String password;


    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http.exceptionHandling().authenticationEntryPoint(new EntryPoint());

        http.httpBasic()
                .and()
                    .authorizeRequests()
                        .antMatchers("/admin/**")
                        .authenticated()
                .anyRequest().permitAll();

        http.csrf().disable();
        http.headers().frameOptions().disable();
    }

    @Override
    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(new BasicAuthenticationProvider());
    }

    public class BasicAuthenticationProvider implements AuthenticationProvider {

        @Override
        public Authentication authenticate(Authentication authentication) throws AuthenticationException {

            String name = authentication.getName();
            String password = authentication.getCredentials().toString();

            //  入力された name / password をチェックする
            if( name.equals(username) && password.equals(password) ){
               return new UsernamePasswordAuthenticationToken(name,password,authentication.getAuthorities());
            }

            throw new AuthenticationCredentialsNotFoundException("basic auth error");
        }

        @Override
        public boolean supports(Class<?> authentication) {
            log.info("------- supports : {}" , authentication);
            return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
        }
    }

    public class EntryPoint implements AuthenticationEntryPoint {

        @Override
        public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException)
                throws IOException, ServletException {

            log.info("===== auth ex {}:{} " , authException.getClass(), authException.getMessage());

            ErrorResponse errorResponse = Response.createErrorResponse(authException);
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(JsonParser.Feature.ALLOW_COMMENTS,true);

            response.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.setCharacterEncoding("UTF-8");

            mapper.writeValue(response.getWriter(),errorResponse);
        }
    }
}
