package com.coltware.springboot.zipcode.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * Created by kobayashi on 2019-02-17.
 */
@Configuration
public class WebConfiguration implements WebMvcConfigurer {

    private static final Logger log = LoggerFactory.getLogger(WebConfiguration.class);


    @Override
    public void addCorsMappings(CorsRegistry registry) {

        log.info("add cors mappings : {}",registry.getClass());

        registry.addMapping("/**")
                .allowedOrigins("*")
                .allowedMethods("GET","HEAD")
                .allowedHeaders("Content-Type",
                        "X-Requested-With",
                        "accept",
                        "Origin",
                        "Access-Control-Request-Method",
                        "Access-Control-Request-Headers")
                .exposedHeaders("Access-Control-Allow-Origin", "Access-Control-Allow-Credentials")
                .allowCredentials(false);
    }

}
