package com.coltware.springboot.zipcode.camel;

import com.coltware.springboot.zipcode.data.model.ZipCode;
import com.coltware.springboot.zipcode.data.repository.ZipCodeRepository;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;

@Component
public class ZipcodeImportRouteBuilder extends RouteBuilder {

    @Autowired
    ZipCodeRepository zipCodeRepository;

    @Override
    public void configure() throws Exception {
        File file = new File(".");

        from("file://" + file.getAbsolutePath() + File.pathSeparator + "import").process((Exchange exchange) -> {
            File importFile = exchange.getIn().getBody(File.class);
            log.info("import file : {}",importFile.getAbsolutePath());

            InputStream is = new FileInputStream(importFile);
            Message in = exchange.getIn();
            in.setBody(is);

        }).to("direct:import");

        from("direct:import").process(new Processor() {
            @Override
            public void process(Exchange exchange) throws Exception {

                Message msg = exchange.getIn();

                Object body = msg.getBody();
                if(body instanceof InputStream){
                    log.info("import start");
                    InputStream is = (InputStream)body;
                    try {
                        importData(is);
                        exchange.getOut().setHeader("Status","OK");
                    }
                    catch(Exception ex){
                        log.error(ex.getMessage(),ex);
                        Message out = exchange.getOut();
                        out.setHeader("Status","Error");
                        out.setBody(ex);
                    }
                    try{
                        is.close();
                    }
                    catch (Exception ex){

                    }
                    log.info("import end");
                }

            }
        });
    }

    /**
     * CSVのインポート
     * @param is
     * @throws UnsupportedEncodingException
     * @throws IOException
     */
    protected void importData(InputStream is) throws UnsupportedEncodingException, IOException{
        BufferedReader br = new BufferedReader(new InputStreamReader(is,"windows-31j"));

        CSVParser parser = CSVFormat.DEFAULT.parse(br);
        for(CSVRecord line : parser){

            String zipcode = line.get(2);
            String pref = line.get(6);
            String city = line.get(7);
            String town = line.get(8);

            ZipCode item = zipCodeRepository.findFirstByUid(zipcode);
            if ( item != null){
                item.setPref(pref);
                item.setCity(city);
                item.setTown(town);
                zipCodeRepository.save(item);
            }
            else{
                item = new ZipCode(zipcode,pref,city,town);
                zipCodeRepository.save(item);
            }
        }
    }
}
