export default class ContactsService{

    constructor(){
        _.extend(this, Backbone.Events);
        this.prefix = window.api;
    }
    list() {
        return this._get("/list");
    }
    addItem(model) {
        return this._post("/add",model)
    }
    loadItem(id){
        return this._get('/item/' + id);
    }
    updateItem(id,model) {
        return this._post("/update/" + id,model)
    }
    deleteItem(id){
        return this._delete("/item/" + id);
    }
    _post(endpoint,data) {
        let postData = JSON.stringify(data);
        console.log("data .....",data,postData);

        let opts = {
            url: this.prefix + endpoint,
            type: 'POST',
            contentType: 'application/json',
            dataType: "json",
            data: postData,
            timeout: 500,
            crossDomain: true
        };

        return $.ajax(opts);
    }
    _get(endpoint) {

        let opts = {
            url: this.prefix + endpoint,
            type: 'GET',
            dataType: "json",
            timeout: 500,
            crossDomain: true
        };

        return $.ajax(opts);
    }
    _delete(endpoint) {

        let opts = {
            url: this.prefix + endpoint,
            type: 'DELETE',
            dataType: "json",
            timeout: 500,
            crossDomain: true
        };

        return $.ajax(opts);
    }
}
