import VRouter from "./routes.js";
import Services from "./services.js";

import ApiError from "./components/ApiError.js";
import ContactForm from "./directives/ContactForm.js";
import FieldValidator from "./directives/FieldValidator.js";

(function(){
    window.$forms = {};
    window.api  = "http://localhost:8081/contact";

    let viewRouter = new VRouter();

    let router = new VueRouter({
        routes : viewRouter.routes()
    });

    let services = new Services();

    Vue.directive('contact-form',ContactForm);
    Vue.directive('form-field',FieldValidator);

    Vue.prototype.$services = services;

    let main = new Vue({
        el : '#app',
        router : router,
        components : {
          'api-error' : ApiError
        },
        data : {
            loading : true,
            error : false
        },
        mounted : function(){
            console.log("mounted....");
            let that = this;
            viewRouter.start(function(){
                that.loading = false;
            });

            this.$services.listenTo(this.$services,'error',function(error){
                console.log("api error",error);
                that.error = error;
            });

            this.$services.listenTo(this.$services,'loading',function(val){
                that.loading = val;
            });
        },
        methods : {
            closeMessage : function(evt){
                this.error = false;
            }
        }
    });

    window.services = services;
}());
