function trigger (el, type, binding) {
    const e = document.createEvent('HTMLEvents');
    e.initEvent(type, false, true);
    el.dispatchEvent(e)
}

export default {
    inserted: function (el,binding,vnode) {
        let name = $(el).attr('name');
        let form = window.$forms[name];

        let lastStatus = undefined;
        let $el = $(el);

        form.listenTo(form,'status',function(name,b){
            if(b){
                if(lastStatus){
                    $el.removeClass(lastStatus);
                }
                $el.addClass(name);
                lastStatus = name;
            }
            else{
                if($el.hasClass(name)){
                    $el.removeClass(name);
                }
                if(lastStatus){
                    $el.removeClass(lastStatus);
                }
                lastStatus = undefined;
            }
        });
    }
}