let AddForm = Backbone.Model.extend({
    initialize : function(){
        console.log("======== form =========");
    },
    validated : function(){
        for(let name in this.attributes){
            if(!this.get(name)){
                return false;
            }
        }
        return true;
    }
});

export default {
    data : function(){
        return {
            form : {

            },
            validation : {
                zip : true,
                address : true,
                name : true,
                tel : true
            },
            validated : 0,
            button : false
        }
    },
    created  : function(){
        let that = this;
        let addForm = new AddForm();
        window.$forms.add = addForm;
        this.$form = addForm;
        addForm.listenTo(addForm,'change',function(){
            let valid = addForm.validated();
            if(valid){
                that.validated = 1;
                that.button = true;
            }
            else{
                that.validated = -1;
                that.button = false;
            }
        });
    },
    methods : {
        add : function(){
            let that = this;
            let s = this.$services.get('ContactService');

            if(!this.$form.validated()){
                this.$form.trigger('status','error',true);
                return;
            }

            this.$services.trigger('loading',true);

            let f = s.addItem(this.form);
            f.fail(function(err,obj){
                that.$services.trigger('error',err);
            });
            f.done(function(){
                that.$form.clear();
                that.validation = {
                    zip : true,
                    address : true,
                    name : true,
                    tel : true
                },
                that.form = {};
                that.$form.trigger('status','success',true);
            });
            f.always(function(){
                that.$services.trigger('loading',false);
            });
            console.log(JSON.stringify(this.form));
        }
    }
}
