import AddController from "./controllers/AddController.js";
import ListController from "./controllers/ListController.js";
import UpdateController from "./controllers/UpdateController.js";

let ViewItem = function (params,queue) {
    let component = params.component;
    return {
        path: params.path,
        name: params.name,
        component: params.component,
        template: '',
        beforeEnter: function (to, from, next) {
            let html = queue.getResult(to.name, true);

            if (!html) {
                queue.on("complete", function () {
                    component.template = queue.getResult(to.name, true);
                    next();
                }, this);
            } else {
                component.template = html;
                next();
            }
        }
    }
};

export default class VRouter{

    constructor(){
        _.extend(this, Backbone.Events);
        this.queue = new createjs.LoadQueue(true);
    }
    routes() {
        return [
            new ViewItem({
            path: '/list',
            name: 'list',
            component: ListController
            },this.queue),
            new ViewItem({
                path: '/add',
                name: 'add',
                component: AddController
            },this.queue),
            new ViewItem({
                path: '/update/:id',
                name : 'update',
                component: UpdateController
            },this.queue)
        ]
    }
    start(callback) {

        this.queue.on("complete", callback);

        this.queue.loadFile({id: "list", src: "views/list.html"});
        this.queue.loadFile({id: "add", src: "views/add.html"});
        this.queue.loadFile({id: "update", src: "views/update.html"});
    }
}