let UpdateForm = Backbone.Model.extend({
    initialize : function(){
        console.log("======== form =========");
    },
    validated : function(){
        for(let name in this.attributes){
            if(!this.get(name)){
                return false;
            }
        }
        return true;
    }
});

export default {
    data : function(){
        return {
            form : {

            },
            validation : {
                zip : true,
                address : true,
                name : true,
                tel : true
            },
            validated : 0,
            button : false
        }
    },
    created  : function(){
        let that = this;
        let updateForm = new UpdateForm();
        window.$forms.update = updateForm;

        let s = this.$services.get('ContactService');

        let ajax = s.loadItem(this.$route.params.id);
        ajax.done(function(json){
            that.form = json.result;
        });

        this.$form = updateForm;
        updateForm.listenTo(updateForm,'change',function(){
            let valid = updateForm.validated();
            if(valid){
                that.validated = 1;
                that.button = true;
            }
            else{
                that.validated = -1;
                that.button = false;
            }
        });
    },
    methods : {
        update : function(){
            let that = this;
            let s = this.$services.get('ContactService');

            if(!this.$form.validated()){
                this.$form.trigger('status','error',true);
                return;
            }

            this.$services.trigger('loading',true);

            let f = s.updateItem(this.$route.params.id,this.form);
            f.fail(function(err,obj){
                that.$services.trigger('error',err);
            });
            f.done(function(json){
                that.$form.clear();
                that.validation = {
                    zip : true,
                    address : true,
                    name : true,
                    tel : true
                };
                that.form = json.result;
                that.$form.trigger('status','success',true);
            });
            f.always(function(){
                that.$services.trigger('loading',false);
            });
        }
    }
}
