function loadList(c){
    let s = c.$services.get('ContactService');

    c.$services.trigger('loading',true);
    let ajax = s.list();
    ajax.done(function(json){
        c.list = json.result;
        c.size = json.result.length;
    });

    ajax.always(function(){
        c.$services.trigger('loading',false);
    });
}

export default {
    data : function(){
        return {
            size : 0,
            list : []
        }
    },
    created : function(){
        loadList(this);
    },
    methods : {
        goUpdate : function(item){
            this.$router.push({ name: 'update', params: { id: item.id }});
        },
        deleteItem : function(item){
            let s = this.$services.get('ContactService');

            let ajax = s.deleteItem(item.id);
            let that = this;
            ajax.done(function(json){
                loadList(that);
            });
        }
    }
};