package com.coltware.contacts.controller;

import com.coltware.contacts.data.ContactModel;
import com.coltware.contacts.data.ContactRepository;
import com.coltware.contacts.controller.response.NotFoundItemException;
import com.coltware.contacts.controller.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.*;

import javax.validation.ValidationException;
import java.util.List;
import java.util.Optional;

@RestController
@Scope("request")
@RequestMapping("/contact")
public class ContactController {

    private static final Logger log = LoggerFactory.getLogger(ContactController.class);

    @Autowired
    ContactRepository contactRepository;

    @PostMapping("/add")
    public Response addAction(@RequestBody(required = false) ContactModel item){

        if( item == null ){
            throw new ValidationException("input date is null");
        }
        contactRepository.save(item);
        return Response.createSuccessResponse(item);
    }

    @GetMapping("/item/{id}")
    public Response itemAction(@PathVariable("id") String id){

        int rid = 0;
        try{
            rid = Integer.valueOf(id);
        }
        catch(Exception ex){
            throw new ValidationException("parameter type error [" + id + "]");
        }

        Optional<ContactModel> model = contactRepository.findById(rid);

        if( !model.isPresent() ){
            throw new NotFoundItemException("not found item : " + id);
        }

        return Response.createSuccessResponse(model.get());
    }

    @DeleteMapping("/item/{id}")
    public Response deleteAction(@PathVariable("id") String id){

        int rid = 0;
        try{
            rid = Integer.valueOf(id);
        }
        catch(Exception ex){
            throw new ValidationException("parameter type error [" + id + "]");
        }

        Optional<ContactModel> model = contactRepository.findById(rid);

        if( !model.isPresent() ){
            throw new NotFoundItemException("not found item : " + id);
        }

        contactRepository.delete(model.get());

        return Response.createSuccessResponse(model.get());
    }

    @PostMapping("/update/{id}")
    public Response updateAction(@PathVariable("id") String id,@RequestBody(required = false) ContactModel item){

        int rid = 0;
        try{
            rid = Integer.valueOf(id);
        }
        catch(Exception ex){
            throw new ValidationException("parameter type error [" + id + "]");
        }

        Optional<ContactModel> model = contactRepository.findById(rid);

        if( !model.isPresent() ){
            throw new NotFoundItemException("not found item : " + id);
        }

        ContactModel updateModel = model.get();
        updateModel.setZip(item.getZip());
        updateModel.setAddress(item.getAddress());
        updateModel.setName(item.getName());
        updateModel.setTel(item.getTel());

        contactRepository.save(updateModel);

        return Response.createSuccessResponse(updateModel);
    }

    @GetMapping("/list")
    public Response listAction(){
        List<ContactModel> list = contactRepository.findAll();
        return Response.createSuccessResponse(list);
    }

}
