package com.coltware.contacts.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfiguration implements WebMvcConfigurer {

    private static final Logger log = LoggerFactory.getLogger(WebConfiguration.class);

    @Value("${app.web.prefix}")
    private String webPrefix;

    @Value("${app.web.resource:classpath:/static/}")
    private String webResource;

    public void addCorsMappings(CorsRegistry registry) {

        registry.addMapping("/contacts/**")
                .allowedOrigins("*")
                .allowedMethods("GET","POST","DELETE")
                .allowedHeaders("Content-Type",
                        "accept",
                        "Origin"
                )
                .allowCredentials(false).maxAge(3600);
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(webPrefix + "/**")
                .addResourceLocations(webResource);
    }
}
