package com.coltware.spring.sample.config;

import com.coltware.spring.sample.model.WorldModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

//(1) Javaベースの設定を示すアノテーション
@Configuration
public class SampleConfiguration {
	 // (2) 設定ファイルから"sample.world"の値で設定する
    @Value("${sample.world:World}")
    String world;
    // (3)aオブジェクトの作成方法を指定する
    @Bean
    public WorldModel worldModel(){
        WorldModel model =  new WorldModel();
        model.setValue(world);
        return model;
    }
}
