package com.coltware.spring.sample.api;

import com.coltware.spring.sample.model.WorldModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

//(1) Rest用のコントローラクラスであることを宣言する
@RestController
//(2) /hello 以下のリクエストに対する処理
@RequestMapping(value = "/hello")
public class HelloController {

    private static final Logger log = LoggerFactory.getLogger(HelloController.class);

    // (3)a 自動的にWorldModelオブジェクトを設定する
    @Autowired
    WorldModel model;

    // (4) GET /hello/world  に対する処理
    @GetMapping(value = "/world")
    public WorldModel world(){
        return model;
    }
    //  (5) POST /hello/world  に対する処理
    @PostMapping(value = "/world")
    public WorldModel setWorld(@RequestBody WorldModel world){
        model.setValue(world.getValue());
        log.info("set value : {}",model.getValue());
        return world;
    }
}