/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multimaps;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LazyParsedDependencyInfo;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.DepsFileParser;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.PathUtil;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DepsGenerator {
    private static final Logger logger = Logger.getLogger(DepsGenerator.class.getName());
    private final Collection<SourceFile> srcs;
    private final Collection<SourceFile> deps;
    private final String closurePathAbs;
    private final InclusionStrategy mergeStrategy;
    private final ModuleLoader loader;
    final ErrorManager errorManager;
    static final DiagnosticType ES6_IMPORT_FOR_NON_ES6_MODULE = DiagnosticType.warning("DEPS_ES6_IMPORT_FOR_NON_ES6_MODULE", "Cannot import file \"{0}\" because it is not an ES6 module.");
    static final DiagnosticType UNKNOWN_PATH_IMPORT = DiagnosticType.warning("DEPS_UNKNOWN_PATH_IMPORT", "Could not find file \"{0}\".");
    static final DiagnosticType SAME_FILE_WARNING = DiagnosticType.warning("DEPS_SAME_FILE", "Namespace \"{0}\" is both required and provided in the same file.");
    static final DiagnosticType NEVER_PROVIDED_ERROR = DiagnosticType.error("DEPS_NEVER_PROVIDED", "Namespace \"{0}\" is required but never provided.\nYou need to pass a library that has it in srcs or exports to your target''s deps.");
    static final DiagnosticType DUPE_PROVIDES_WARNING = DiagnosticType.warning("DEPS_DUPE_PROVIDES", "Multiple calls to goog.provide(\"{0}\")");
    static final DiagnosticType MULTIPLE_PROVIDES_ERROR = DiagnosticType.error("DEPS_DUPE_PROVIDES", "Namespace \"{0}\" is already provided in other file {1}");
    static final DiagnosticType DUPE_REQUIRE_WARNING = DiagnosticType.warning("DEPS_DUPE_REQUIRES", "Namespace \"{0}\" is required multiple times");
    static final DiagnosticType NO_DEPS_WARNING = DiagnosticType.warning("DEPS_NO_DEPS", "No dependencies found in file");

    public DepsGenerator(Collection<SourceFile> deps, Collection<SourceFile> srcs, InclusionStrategy mergeStrategy, String closurePathAbs, ErrorManager errorManager, ModuleLoader loader) {
        this.deps = deps;
        this.srcs = srcs;
        this.mergeStrategy = mergeStrategy;
        this.closurePathAbs = closurePathAbs;
        this.errorManager = errorManager;
        this.loader = loader;
    }

    public String computeDependencyCalls() throws IOException {
        Map<String, DependencyInfo> depsFiles = this.parseDepsFiles();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("preparsedFiles: " + depsFiles);
        }
        Map<String, DependencyInfo> jsFiles = this.parseSources(depsFiles.keySet());
        if (this.errorManager.getErrorCount() > 0) {
            return null;
        }
        this.cleanUpDuplicatedFiles(depsFiles, jsFiles);
        jsFiles = this.removeMungedSymbols(depsFiles, jsFiles);
        this.validateDependencies(depsFiles.values(), jsFiles.values());
        if (this.errorManager.getErrorCount() > 0) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeDepsContent(depsFiles, jsFiles, new PrintStream(output));
        return new String(output.toByteArray(), StandardCharsets.UTF_8);
    }

    protected void cleanUpDuplicatedFiles(Map<String, DependencyInfo> depsFiles, Map<String, DependencyInfo> jsFiles) {
        HashSet<String> depsPathsCopy = new HashSet<String>(depsFiles.keySet());
        for (String path : depsPathsCopy) {
            if (this.mergeStrategy == InclusionStrategy.WHEN_IN_SRCS) continue;
            jsFiles.remove(path);
        }
        for (String path : jsFiles.keySet()) {
            depsFiles.remove(path);
        }
    }

    private Map<String, DependencyInfo> removeMungedSymbols(Map<String, DependencyInfo> depFiles, Map<String, DependencyInfo> jsFiles) {
        LinkedHashMap<String, DependencyInfo> newJsFiles = new LinkedHashMap<String, DependencyInfo>();
        LinkedHashMap<String, DependencyInfo> providesMap = new LinkedHashMap<String, DependencyInfo>();
        this.addToProvideMap(depFiles.values(), providesMap, true);
        this.addToProvideMap(jsFiles.values(), providesMap, false);
        for (DependencyInfo dependencyInfo : jsFiles.values()) {
            ArrayList<DependencyInfo.Require> newRequires = new ArrayList<DependencyInfo.Require>();
            for (DependencyInfo.Require require : dependencyInfo.getRequires()) {
                if (require.getType() == DependencyInfo.Require.Type.ES6_IMPORT) {
                    DependencyInfo provider = (DependencyInfo)providesMap.get(require.getSymbol());
                    if (provider == null) {
                        this.reportMissingFile(dependencyInfo, require.getRawText());
                        continue;
                    }
                    newRequires.add(require.withSymbol(provider.getPathRelativeToClosureBase()));
                    continue;
                }
                newRequires.add(require);
            }
            ImmutableCollection provides = dependencyInfo.getProvides();
            if ("es6".equals(dependencyInfo.getLoadFlags().get("module"))) {
                String mungedProvide = this.loader.resolve(dependencyInfo.getName()).toModuleName();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (String provide : provides) {
                    if (provide.equals(mungedProvide) || provide.equals(dependencyInfo.getPathRelativeToClosureBase())) continue;
                    builder.add(provide);
                }
                provides = builder.build();
            }
            newJsFiles.put(dependencyInfo.getPathRelativeToClosureBase(), SimpleDependencyInfo.builder(dependencyInfo.getPathRelativeToClosureBase(), dependencyInfo.getName()).setProvides(provides).setRequires(newRequires).setLoadFlags(dependencyInfo.getLoadFlags()).build());
        }
        return newJsFiles;
    }

    private void validateDependencies(Iterable<DependencyInfo> preparsedFileDependencies, Iterable<DependencyInfo> parsedFileDependencies) {
        LinkedHashMap<String, DependencyInfo> providesMap = new LinkedHashMap<String, DependencyInfo>();
        this.addToProvideMap(preparsedFileDependencies, providesMap, true);
        this.addToProvideMap(parsedFileDependencies, providesMap, false);
        for (DependencyInfo depInfo : parsedFileDependencies) {
            ImmutableMultiset<String> symbols = ImmutableMultiset.copyOf(depInfo.getRequiredSymbols());
            for (String symbol : symbols.elementSet()) {
                if (symbols.count(symbol) <= 1) continue;
                this.reportDuplicateRequire(symbol, depInfo);
            }
            block6: for (DependencyInfo.Require require : depInfo.getRequires()) {
                String namespace = require.getSymbol();
                DependencyInfo provider = (DependencyInfo)providesMap.get(namespace);
                if (provider == null) {
                    this.reportUndefinedNamespace(namespace, depInfo);
                    continue;
                }
                if (provider == depInfo) {
                    this.reportSameFile(namespace, depInfo);
                    continue;
                }
                depInfo.isModule();
                boolean providerIsEs6Module = "es6".equals(provider.getLoadFlags().get("module"));
                switch (require.getType()) {
                    case ES6_IMPORT: {
                        if (providerIsEs6Module) continue block6;
                        this.reportEs6ImportForNonEs6Module(provider, depInfo);
                        continue block6;
                    }
                    case GOOG_REQUIRE_SYMBOL: 
                    case PARSED_FROM_DEPS: {
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unexpected import type: " + (Object)((Object)require.getType()));
            }
        }
    }

    private void reportMissingFile(DependencyInfo depInfo, String path) {
        this.errorManager.report(CheckLevel.ERROR, JSError.make(depInfo.getName(), -1, -1, UNKNOWN_PATH_IMPORT, path));
    }

    private void reportEs6ImportForNonEs6Module(DependencyInfo provider, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.ERROR, JSError.make(depInfo.getName(), -1, -1, ES6_IMPORT_FOR_NON_ES6_MODULE, provider.getName()));
    }

    private void reportSameFile(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(depInfo.getName(), -1, -1, SAME_FILE_WARNING, namespace));
    }

    private void reportUndefinedNamespace(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.ERROR, JSError.make(depInfo.getName(), -1, -1, NEVER_PROVIDED_ERROR, namespace));
    }

    private void reportDuplicateProvide(String namespace, DependencyInfo firstDep, DependencyInfo secondDep) {
        if (firstDep == secondDep) {
            if (!firstDep.getPathRelativeToClosureBase().equals(namespace)) {
                this.errorManager.report(CheckLevel.WARNING, JSError.make(firstDep.getName(), -1, -1, DUPE_PROVIDES_WARNING, namespace));
            }
        } else {
            this.errorManager.report(CheckLevel.ERROR, JSError.make(secondDep.getName(), -1, -1, MULTIPLE_PROVIDES_ERROR, namespace, firstDep.getName()));
        }
    }

    private void reportDuplicateRequire(String namespace, DependencyInfo depInfo) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(depInfo.getName(), -1, -1, DUPE_REQUIRE_WARNING, namespace));
    }

    private void reportNoDepsInDepsFile(String filePath) {
        this.errorManager.report(CheckLevel.WARNING, JSError.make(filePath, -1, -1, NO_DEPS_WARNING, new String[0]));
    }

    private void addToProvideMap(Iterable<DependencyInfo> depInfos, Map<String, DependencyInfo> providesMap, boolean isFromDepsFile) {
        for (DependencyInfo depInfo : depInfos) {
            ArrayList<String> provides = new ArrayList<String>(depInfo.getProvides());
            if (isFromDepsFile) {
                provides.add(this.loader.resolve(PathUtil.makeAbsolute(depInfo.getPathRelativeToClosureBase(), this.closurePathAbs)).toModuleName());
            } else if (!"es6".equals(depInfo.getLoadFlags().get("module"))) {
                provides.add(this.loader.resolve(depInfo.getName()).toModuleName());
            }
            provides.add(depInfo.getPathRelativeToClosureBase());
            for (String provide : provides) {
                DependencyInfo prevValue = providesMap.put(provide, depInfo);
                if (prevValue == null) continue;
                this.reportDuplicateProvide(provide, prevValue, depInfo);
            }
        }
    }

    protected DepsFileParser createDepsFileParser() {
        DepsFileParser depsParser = new DepsFileParser(this.errorManager);
        depsParser.setShortcutMode(true);
        return depsParser;
    }

    protected boolean shouldSkipDepsFile(SourceFile file) {
        return false;
    }

    private Map<String, DependencyInfo> parseDepsFiles() throws IOException {
        DepsFileParser depsParser = this.createDepsFileParser();
        LinkedHashMap<String, DependencyInfo> depsFiles = new LinkedHashMap<String, DependencyInfo>();
        for (SourceFile file : this.deps) {
            if (this.shouldSkipDepsFile(file)) continue;
            List<DependencyInfo> depInfos = depsParser.parseFileReader(file.getName(), file.getCodeReader());
            if (depInfos.isEmpty()) {
                this.reportNoDepsInDepsFile(file.getName());
                continue;
            }
            for (DependencyInfo info : depInfos) {
                depsFiles.put(info.getPathRelativeToClosureBase(), this.removeRelativePathProvide(info));
            }
        }
        for (SourceFile src : this.srcs) {
            if (this.shouldSkipDepsFile(src)) continue;
            List<DependencyInfo> srcInfos = depsParser.parseFileReader(src.getName(), src.getCodeReader());
            for (DependencyInfo info : srcInfos) {
                depsFiles.put(info.getPathRelativeToClosureBase(), this.removeRelativePathProvide(info));
            }
        }
        return depsFiles;
    }

    private DependencyInfo removeRelativePathProvide(DependencyInfo info) {
        return SimpleDependencyInfo.Builder.from(info).setProvides(info.getProvides().stream().filter(p -> !p.equals(info.getPathRelativeToClosureBase())).collect(Collectors.toList())).build();
    }

    private Map<String, DependencyInfo> parseSources(Set<String> preparsedFiles) throws IOException {
        LinkedHashMap<String, DependencyInfo> parsedFiles = new LinkedHashMap<String, DependencyInfo>();
        JsFileParser jsParser = new JsFileParser(this.errorManager).setModuleLoader(this.loader);
        Compiler compiler = new Compiler();
        compiler.init(ImmutableList.of(), ImmutableList.of(), new CompilerOptions());
        for (SourceFile file : this.srcs) {
            String closureRelativePath = PathUtil.makeRelative(this.closurePathAbs, PathUtil.makeAbsolute(file.getName()));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Closure-relative path: " + closureRelativePath);
            }
            if (InclusionStrategy.WHEN_IN_SRCS != this.mergeStrategy && preparsedFiles.contains(closureRelativePath)) continue;
            DependencyInfo depInfo = jsParser.parseFile(file.getName(), closureRelativePath, file.getCode());
            depInfo = new LazyParsedDependencyInfo(depInfo, new JsAst(file), compiler);
            file.clearCachedSource();
            parsedFiles.put(closureRelativePath, depInfo);
        }
        return parsedFiles;
    }

    private void writeDepsContent(Map<String, DependencyInfo> depsFiles, Map<String, DependencyInfo> jsFiles, PrintStream out) throws IOException {
        DepsGenerator.writeDepInfos(out, jsFiles.values());
        if (this.mergeStrategy == InclusionStrategy.ALWAYS) {
            ImmutableListMultimap<String, DependencyInfo> infosIndex = Multimaps.index(depsFiles.values(), DependencyInfo::getName);
            for (String depsPath : infosIndex.keySet()) {
                String path = this.formatPathToDepsFile(depsPath);
                out.println("\n// Included from: " + path);
                DepsGenerator.writeDepInfos(out, infosIndex.get(depsPath));
            }
        }
    }

    protected String formatPathToDepsFile(String path) {
        return path;
    }

    private static void writeDepInfos(PrintStream out, Collection<DependencyInfo> depInfos) throws IOException {
        for (DependencyInfo depInfo : depInfos) {
            DependencyInfo.Util.writeAddDependency(out, depInfo);
        }
    }

    static List<SourceFile> createSourceFilesFromPaths(Collection<String> paths) {
        ArrayList<SourceFile> files = new ArrayList<SourceFile>();
        for (String path : paths) {
            files.add(SourceFile.fromFile(path));
        }
        return files;
    }

    static List<SourceFile> createSourceFilesFromPaths(String ... paths) {
        return DepsGenerator.createSourceFilesFromPaths(Arrays.asList(paths));
    }

    static List<SourceFile> createSourceFilesFromZipPaths(Collection<String> paths) throws IOException {
        ArrayList<SourceFile> zipSourceFiles = new ArrayList<SourceFile>();
        for (String path : paths) {
            zipSourceFiles.addAll(SourceFile.fromZipFile(path, StandardCharsets.UTF_8));
        }
        return zipSourceFiles;
    }

    public static enum InclusionStrategy {
        ALWAYS,
        WHEN_IN_SRCS,
        DO_NOT_DUPLICATE;

    }
}

