/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RewriteJsonToModule
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType JSON_UNEXPECTED_TOKEN = DiagnosticType.error("JSC_JSON_UNEXPECTED_TOKEN", "Unexpected JSON token");
    private final Map<String, String> packageJsonMainEntries;
    private final AbstractCompiler compiler;

    public RewriteJsonToModule(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.packageJsonMainEntries = new HashMap<String, String>();
    }

    public ImmutableMap<String, String> getPackageJsonMainEntries() {
        return ImmutableMap.copyOf(this.packageJsonMainEntries);
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState(root.isScript());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case SCRIPT: {
                if (!n.hasOneChild()) {
                    this.compiler.report(JSError.make(n, JSON_UNEXPECTED_TOKEN, new String[0]));
                } else {
                    this.visitScript(t, n);
                }
                return;
            }
            case OBJECTLIT: 
            case ARRAYLIT: 
            case NUMBER: 
            case TRUE: 
            case FALSE: 
            case NULL: 
            case STRING: {
                break;
            }
            case STRING_KEY: {
                if (n.isQuotedString() && n.hasOneChild()) break;
                this.compiler.report(JSError.make(n, JSON_UNEXPECTED_TOKEN, new String[0]));
                break;
            }
            case EXPR_RESULT: {
                if (parent.isScript()) break;
                this.compiler.report(JSError.make(n, JSON_UNEXPECTED_TOKEN, new String[0]));
                break;
            }
            default: {
                this.compiler.report(JSError.make(n, JSON_UNEXPECTED_TOKEN, new String[0]));
            }
        }
        if (n.getLineno() == 1) {
            n.setCharno(n.getCharno() - 1);
            t.reportCodeChange();
        }
    }

    private void visitScript(NodeTraversal t, Node n) {
        if (!n.hasOneChild() || !n.getFirstChild().isExprResult()) {
            this.compiler.report(JSError.make(n, JSON_UNEXPECTED_TOKEN, new String[0]));
            return;
        }
        Node jsonObject = n.getFirstFirstChild().detach();
        n.removeFirstChild();
        String moduleName = t.getInput().getPath().toModuleName();
        n.addChildToFront(IR.var(IR.name(moduleName).useSourceInfoFrom(jsonObject), jsonObject).useSourceInfoFrom(jsonObject));
        n.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).useSourceInfoIfMissingFromForTree(n));
        String inputPath = t.getInput().getSourceFile().getOriginalPath();
        if (inputPath.endsWith("/package.json") && jsonObject.isObjectLit()) {
            List<String> possibleMainEntries = this.compiler.getOptions().getPackageJsonEntryNames();
            for (String entryName : possibleMainEntries) {
                Node entry = NodeUtil.getFirstPropMatchingKey(jsonObject, entryName);
                if (entry == null || !entry.isString() && !entry.isObjectLit()) continue;
                String dirName = inputPath.substring(0, inputPath.length() - "package.json".length());
                if (entry.isString()) {
                    this.packageJsonMainEntries.put(inputPath, dirName + entry.getString());
                    break;
                }
                if (!entry.isObjectLit()) continue;
                Preconditions.checkState(entryName.equals("browser"), entryName);
                this.processBrowserFieldAdvancedUsage(dirName, entry);
            }
        }
        t.reportCodeChange();
    }

    private void processBrowserFieldAdvancedUsage(String dirName, Node entry) {
        for (Node child : entry.children()) {
            Node value = child.getFirstChild();
            Preconditions.checkState(child.isStringKey() && (value.isString() || value.isFalse()));
            String path = child.getString();
            if (path.startsWith("./")) {
                path = path.substring("./".length());
            }
            String replacement = value.isString() ? dirName + value.getString() : "$jscomp$browser$blacklisted";
            this.packageJsonMainEntries.put(dirName + path, replacement);
        }
    }
}

