/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckJSDoc;
import com.google.javascript.jscomp.CheckMissingAndExtraRequires;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckSuper;
import com.google.javascript.jscomp.CheckTypeImportCodeReferences;
import com.google.javascript.jscomp.ClosureCheckModule;
import com.google.javascript.jscomp.ClosureRewriteClass;
import com.google.javascript.jscomp.CombinedCompilerPass;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultPassConfig;
import com.google.javascript.jscomp.GatherModuleMetadata;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.VariableReferenceCheck;
import com.google.javascript.jscomp.lint.CheckDuplicateCase;
import com.google.javascript.jscomp.lint.CheckEmptyStatements;
import com.google.javascript.jscomp.lint.CheckEnums;
import com.google.javascript.jscomp.lint.CheckInterfaces;
import com.google.javascript.jscomp.lint.CheckJSDocStyle;
import com.google.javascript.jscomp.lint.CheckMissingSemicolon;
import com.google.javascript.jscomp.lint.CheckNullabilityModifiers;
import com.google.javascript.jscomp.lint.CheckPrimitiveAsObject;
import com.google.javascript.jscomp.lint.CheckPrototypeProperties;
import com.google.javascript.jscomp.lint.CheckProvidesSorted;
import com.google.javascript.jscomp.lint.CheckRequiresSorted;
import com.google.javascript.jscomp.lint.CheckUnusedLabels;
import com.google.javascript.jscomp.lint.CheckUselessBlocks;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import java.util.List;

class LintPassConfig
extends PassConfig.PassConfigDelegate {
    private final PassFactory.HotSwapPassFactory gatherModuleMetadataPass = new PassFactory.HotSwapPassFactory("gatherModuleMetadata"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GatherModuleMetadata(compiler, compiler.getOptions().getProcessCommonJSModules(), compiler.getOptions().getModuleResolutionMode());
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory earlyLintChecks = new PassFactory("earlyLintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, ImmutableList.of(new CheckDuplicateCase(compiler), new CheckEmptyStatements(compiler), new CheckEnums(compiler), new CheckJSDocStyle(compiler), new CheckJSDoc(compiler), new CheckMissingSemicolon(compiler), new CheckSuper(compiler), new CheckPrimitiveAsObject(compiler), new ClosureCheckModule(compiler, compiler.getModuleMetadataMap()), new CheckNullabilityModifiers(compiler), new CheckProvidesSorted(CheckProvidesSorted.Mode.COLLECT_AND_REPORT), new CheckRequiresSorted(CheckRequiresSorted.Mode.COLLECT_AND_REPORT), new NodeTraversal.Callback[]{new CheckSideEffects(compiler, true, false), new CheckTypeImportCodeReferences(compiler), new CheckUnusedLabels(compiler), new CheckUselessBlocks(compiler)}));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory variableReferenceCheck = new PassFactory("variableReferenceCheck", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new VariableReferenceCheck(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory checkRequires = new PassFactory("checkMissingAndExtraRequires", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CheckMissingAndExtraRequires(compiler, CheckMissingAndExtraRequires.Mode.SINGLE_FILE);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory closureRewriteClass = new PassFactory("closureRewriteClass", true){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new ClosureRewriteClass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };
    private final PassFactory lateLintChecks = new PassFactory("lateLintChecks", true){

        @Override
        protected CompilerPass create(AbstractCompiler compiler) {
            return new CombinedCompilerPass(compiler, ImmutableList.of(new CheckInterfaces(compiler), new CheckPrototypeProperties(compiler)));
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.latest().withoutTypes();
        }
    };

    LintPassConfig(CompilerOptions options) {
        super(new DefaultPassConfig(options));
    }

    @Override
    protected List<PassFactory> getChecks() {
        return ImmutableList.of(this.gatherModuleMetadataPass, this.earlyLintChecks, this.checkRequires, this.variableReferenceCheck, this.closureRewriteClass, this.lateLintChecks);
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }
}

