/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.List;

public final class ImplicitNullabilityCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType IMPLICITLY_NULLABLE_JSDOC = DiagnosticType.disabled("JSC_IMPLICITLY_NULLABLE_JSDOC", "Name {0} in JSDoc is implicitly nullable, and is discouraged by the style guide.\nPlease add a '!' to make it non-nullable, or a '?' to make it explicitly nullable.");
    private final AbstractCompiler compiler;

    public ImplicitNullabilityCheck(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node p) {
        JSDocInfo info = n.getJSDocInfo();
        if (info == null) {
            return;
        }
        final JSTypeRegistry registry = this.compiler.getTypeRegistry();
        final List<Node> thrownTypes = Lists.transform(info.getThrownTypes(), new Function<JSTypeExpression, Node>(){

            @Override
            public Node apply(JSTypeExpression expr) {
                return expr.getRoot();
            }
        });
        final Scope scope = t.getScope();
        for (Node typeRoot : info.getTypeNodes()) {
            NodeUtil.visitPreOrder(typeRoot, new NodeUtil.Visitor(){

                @Override
                public void visit(Node node) {
                    String typeName;
                    if (!node.isString()) {
                        return;
                    }
                    if (thrownTypes.contains(node)) {
                        return;
                    }
                    Node parent = node.getParent();
                    if (parent != null) {
                        switch (parent.getToken()) {
                            case BANG: 
                            case QMARK: 
                            case THIS: 
                            case NEW: 
                            case TYPEOF: {
                                return;
                            }
                            case PIPE: {
                                Node gp = parent.getParent();
                                if (gp != null && gp.getToken() == Token.QMARK) {
                                    return;
                                }
                                for (Node child : parent.children()) {
                                    if ((!child.isString() || !child.getString().equals("null")) && child.getToken() != Token.QMARK) continue;
                                    return;
                                }
                                break;
                            }
                        }
                    }
                    if ((typeName = node.getString()).equals("null") || registry.getType(scope, typeName) == null) {
                        return;
                    }
                    JSType type = registry.createTypeFromCommentNode(node);
                    if (type.isNullable()) {
                        ImplicitNullabilityCheck.this.compiler.report(JSError.make(node, IMPLICITLY_NULLABLE_JSDOC, typeName));
                    }
                }
            }, Predicates.alwaysTrue());
        }
    }
}

