/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnalyzePrototypeProperties;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.IdGenerator;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.Iterator;

class CrossChunkMethodMotion
implements CompilerPass {
    static final DiagnosticType NULL_COMMON_MODULE_ERROR = DiagnosticType.error("JSC_INTERNAL_ERROR_MODULE_DEPEND", "null deepest common module");
    private final AbstractCompiler compiler;
    private final IdGenerator idGenerator;
    private final AnalyzePrototypeProperties analyzer;
    private final JSModuleGraph moduleGraph;
    private final boolean noStubFunctions;
    private final AstFactory astFactory;
    static final String STUB_METHOD_NAME = "JSCompiler_stubMethod";
    static final String UNSTUB_METHOD_NAME = "JSCompiler_unstubMethod";
    static final String STUB_DECLARATIONS = "var JSCompiler_stubMap = [];function JSCompiler_stubMethod(JSCompiler_stubMethod_id) {  return function() {    return JSCompiler_stubMap[JSCompiler_stubMethod_id].apply(        this, arguments);  };}function JSCompiler_unstubMethod(    JSCompiler_unstubMethod_id, JSCompiler_unstubMethod_body) {  return JSCompiler_stubMap[JSCompiler_unstubMethod_id] =       JSCompiler_unstubMethod_body;}";

    CrossChunkMethodMotion(AbstractCompiler compiler, IdGenerator idGenerator, boolean canModifyExterns, boolean noStubFunctions) {
        this.compiler = compiler;
        this.idGenerator = idGenerator;
        this.moduleGraph = compiler.getModuleGraph();
        this.analyzer = new AnalyzePrototypeProperties(compiler, this.moduleGraph, canModifyExterns, false, noStubFunctions);
        this.noStubFunctions = noStubFunctions;
        this.astFactory = compiler.createAstFactory();
    }

    @Override
    public void process(Node externRoot, Node root) {
        if (this.moduleGraph.getModuleCount() > 1) {
            this.analyzer.process(externRoot, root);
            this.moveMethods(this.analyzer.getAllNameInfo());
        }
    }

    private void moveMethods(Collection<AnalyzePrototypeProperties.NameInfo> allNameInfo) {
        boolean hasStubDeclaration = this.idGenerator.hasGeneratedAnyIds();
        for (AnalyzePrototypeProperties.NameInfo nameInfo : allNameInfo) {
            if (!nameInfo.isReferenced() || nameInfo.readsClosureVariables()) continue;
            JSModule deepestCommonModuleRef = nameInfo.getDeepestCommonModuleRef();
            if (deepestCommonModuleRef == null) {
                this.compiler.report(JSError.make(NULL_COMMON_MODULE_ERROR, new String[0]));
                continue;
            }
            Iterator<AnalyzePrototypeProperties.Symbol> declarations = nameInfo.getDeclarations().descendingIterator();
            while (declarations.hasNext()) {
                AnalyzePrototypeProperties.Symbol symbol = declarations.next();
                if (symbol instanceof AnalyzePrototypeProperties.PrototypeProperty) {
                    this.tryToMovePrototypeMethod(nameInfo, deepestCommonModuleRef, (AnalyzePrototypeProperties.PrototypeProperty)symbol);
                    continue;
                }
                if (!(symbol instanceof AnalyzePrototypeProperties.ClassMemberFunction)) continue;
                this.tryToMoveMemberFunction(nameInfo, deepestCommonModuleRef, (AnalyzePrototypeProperties.ClassMemberFunction)symbol);
            }
        }
        if (!this.noStubFunctions && !hasStubDeclaration && this.idGenerator.hasGeneratedAnyIds()) {
            Node declarations = this.compiler.parseSyntheticCode(STUB_DECLARATIONS);
            NodeUtil.markNewScopesChanged(declarations, this.compiler);
            Node firstScript = this.compiler.getNodeForCodeInsertion(null);
            firstScript.addChildrenToFront(declarations.removeChildren());
            this.compiler.reportChangeToEnclosingScope(firstScript);
        }
    }

    private void tryToMovePrototypeMethod(AnalyzePrototypeProperties.NameInfo nameInfo, JSModule deepestCommonModuleRef, AnalyzePrototypeProperties.PrototypeProperty prop) {
        if (prop.getRootVar() == null || !prop.getRootVar().isGlobal()) {
            return;
        }
        Node value = prop.getValue();
        Node valueParent = value.getParent();
        if (!value.isFunction() || valueParent.isGetterDef() || valueParent.isSetterDef()) {
            return;
        }
        if (this.moduleGraph.dependsOn(deepestCommonModuleRef, prop.getModule())) {
            if (CrossChunkMethodMotion.hasUnmovableRedeclaration(nameInfo, prop)) {
                return;
            }
            Node destParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
            if (valueParent.isMemberFunctionDef()) {
                this.movePrototypeObjectLiteralMethodShorthand(nameInfo.name, destParent, value);
            } else if (valueParent.isStringKey()) {
                this.movePrototypeObjectLiteralProperty(nameInfo.name, destParent, value);
            } else {
                Preconditions.checkState(valueParent.isAssign(), valueParent);
                this.movePrototypeDotMethodAssignment(destParent, value);
            }
        }
    }

    private void movePrototypeObjectLiteralProperty(String propName, Node destParent, Node functionNode) {
        Preconditions.checkState(functionNode.isFunction(), functionNode);
        Node stringKey = functionNode.getParent();
        Preconditions.checkState(stringKey.isStringKey(), stringKey);
        Node prototypeObjectLiteral = stringKey.getParent();
        Preconditions.checkState(prototypeObjectLiteral.isObjectLit(), prototypeObjectLiteral);
        Node assignNode = prototypeObjectLiteral.getParent();
        Preconditions.checkState(assignNode.isAssign() && prototypeObjectLiteral.isSecondChildOf(assignNode), assignNode);
        Node ownerDotPrototypeNode = assignNode.getFirstChild();
        Preconditions.checkState(ownerDotPrototypeNode.isQualifiedName() && ownerDotPrototypeNode.getLastChild().getString().equals("prototype"), ownerDotPrototypeNode);
        if (this.noStubFunctions) {
            stringKey.detach();
            this.compiler.reportChangeToEnclosingScope(prototypeObjectLiteral);
            Node ownerDotPrototypeDotPropName = this.astFactory.createGetProp(ownerDotPrototypeNode.cloneTree(), propName);
            functionNode.detach();
            Node definitionStatement = this.astFactory.createAssignStatement(ownerDotPrototypeDotPropName, functionNode).useSourceInfoIfMissingFromForTree(stringKey);
            destParent.addChildToFront(definitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        } else {
            int stubId = this.idGenerator.newId();
            Node stubCall = this.createStubCall(functionNode, stubId);
            functionNode.replaceWith(stubCall);
            this.compiler.reportChangeToEnclosingScope(prototypeObjectLiteral);
            Node ownerDotPrototypeDotPropName = this.astFactory.createGetProp(ownerDotPrototypeNode.cloneTree(), propName);
            Node unstubCall = this.createUnstubCall(functionNode, stubId);
            Node definitionStatement = this.astFactory.createAssignStatement(ownerDotPrototypeDotPropName, unstubCall).useSourceInfoIfMissingFromForTree(stringKey);
            destParent.addChildToFront(definitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        }
    }

    private void movePrototypeDotMethodAssignment(Node destParent, Node functionNode) {
        Preconditions.checkState(functionNode.isFunction(), functionNode);
        Node assignNode = functionNode.getParent();
        Preconditions.checkState(assignNode.isAssign() && functionNode.isSecondChildOf(assignNode), assignNode);
        Node definitionStatement = assignNode.getParent();
        Preconditions.checkState(definitionStatement.isExprResult(), assignNode);
        if (this.noStubFunctions) {
            Node assignStatementParent = definitionStatement.getParent();
            definitionStatement.detach();
            this.compiler.reportChangeToEnclosingScope(assignStatementParent);
            destParent.addChildToFront(definitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        } else {
            int stubId = this.idGenerator.newId();
            Node originalDefinitionPlaceholder = this.astFactory.createEmpty();
            functionNode.replaceWith(originalDefinitionPlaceholder);
            Node newDefinitionStatement = definitionStatement.cloneTree();
            Node newDefinitionPlaceholder = newDefinitionStatement.getOnlyChild().getLastChild();
            Node stubCall = this.createStubCall(functionNode, stubId);
            originalDefinitionPlaceholder.replaceWith(stubCall);
            this.compiler.reportChangeToEnclosingScope(definitionStatement);
            Node unstubCall = this.createUnstubCall(functionNode, stubId);
            newDefinitionPlaceholder.replaceWith(unstubCall);
            destParent.addChildToFront(newDefinitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        }
    }

    private void movePrototypeObjectLiteralMethodShorthand(String propName, Node destParent, Node functionNode) {
        Preconditions.checkState(functionNode.isFunction(), functionNode);
        Node memberFunctionDef = functionNode.getParent();
        Preconditions.checkState(memberFunctionDef.isMemberFunctionDef(), memberFunctionDef);
        Node prototypeObjectLiteral = memberFunctionDef.getParent();
        Preconditions.checkState(prototypeObjectLiteral.isObjectLit(), prototypeObjectLiteral);
        Node assignNode = prototypeObjectLiteral.getParent();
        Preconditions.checkState(assignNode.isAssign() && prototypeObjectLiteral.isSecondChildOf(assignNode), assignNode);
        Node ownerDotPrototypeNode = assignNode.getFirstChild();
        Preconditions.checkState(ownerDotPrototypeNode.isQualifiedName() && ownerDotPrototypeNode.getLastChild().getString().equals("prototype"), ownerDotPrototypeNode);
        if (this.noStubFunctions) {
            memberFunctionDef.detach();
            this.compiler.reportChangeToEnclosingScope(prototypeObjectLiteral);
            Node ownerDotPrototypeDotPropName = this.astFactory.createGetProp(ownerDotPrototypeNode.cloneTree(), propName);
            Node definitionStatement = this.astFactory.createAssignStatement(ownerDotPrototypeDotPropName, functionNode.detach()).useSourceInfoIfMissingFromForTree(memberFunctionDef);
            destParent.addChildToFront(definitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        } else {
            int stubId = this.idGenerator.newId();
            Node stubCall = this.createStubCall(functionNode, stubId);
            memberFunctionDef.replaceWith(this.astFactory.createStringKey(propName, stubCall));
            this.compiler.reportChangeToEnclosingScope(prototypeObjectLiteral);
            Node ownerDotPrototypeDotPropName = this.astFactory.createGetProp(ownerDotPrototypeNode.cloneTree(), propName);
            Node unstubCall = this.createUnstubCall(functionNode.detach(), stubId);
            Node definitionStatement = this.astFactory.createAssignStatement(ownerDotPrototypeDotPropName, unstubCall).useSourceInfoIfMissingFromForTree(memberFunctionDef);
            destParent.addChildToFront(definitionStatement);
            this.compiler.reportChangeToEnclosingScope(destParent);
        }
    }

    private Node createStubCall(Node originalDefinition, int stubId) {
        return this.astFactory.createCall(this.astFactory.createNameWithUnknownType(STUB_METHOD_NAME), this.astFactory.createNumber(stubId)).useSourceInfoIfMissingFromForTree(originalDefinition);
    }

    private Node createUnstubCall(Node functionNode, int stubId) {
        return this.astFactory.createCall(this.astFactory.createNameWithUnknownType(UNSTUB_METHOD_NAME), this.astFactory.createNumber(stubId), functionNode).useSourceInfoIfMissingFromForTree(functionNode);
    }

    private void tryToMoveMemberFunction(AnalyzePrototypeProperties.NameInfo nameInfo, JSModule deepestCommonModuleRef, AnalyzePrototypeProperties.ClassMemberFunction classMemberFunction) {
        Var rootVar = classMemberFunction.getRootVar();
        if (rootVar == null || !rootVar.isGlobal()) {
            return;
        }
        Node definitionNode = classMemberFunction.getDefinitionNode();
        if (!definitionNode.isMemberFunctionDef()) {
            return;
        }
        if (this.moduleGraph.dependsOn(deepestCommonModuleRef, classMemberFunction.getModule())) {
            if (CrossChunkMethodMotion.hasUnmovableRedeclaration(nameInfo, classMemberFunction)) {
                return;
            }
            Node destinationParent = this.compiler.getNodeForCodeInsertion(deepestCommonModuleRef);
            String className = rootVar.getName();
            if (this.noStubFunctions) {
                this.moveClassInstanceMethodWithoutStub(className, definitionNode, destinationParent);
            } else {
                this.moveClassInstanceMethodWithStub(className, definitionNode, destinationParent);
            }
        }
    }

    private void moveClassInstanceMethodWithoutStub(String className, Node methodDefinition, Node destinationParent) {
        Preconditions.checkArgument(methodDefinition.isMemberFunctionDef(), methodDefinition);
        Node classMembers = Preconditions.checkNotNull(methodDefinition.getParent());
        Preconditions.checkState(classMembers.isClassMembers(), classMembers);
        Node classNode = classMembers.getParent();
        Preconditions.checkState(classNode.isClass(), classNode);
        methodDefinition.detach();
        this.compiler.reportChangeToEnclosingScope(classMembers);
        Node classNameDotPrototypeDotPropName = this.astFactory.createGetProps(this.astFactory.createName(className, classNode.getJSType()), "prototype", methodDefinition.getString());
        Node functionNode = Preconditions.checkNotNull(methodDefinition.getOnlyChild());
        functionNode.detach();
        Node definitionStatementNode = this.astFactory.createAssignStatement(classNameDotPrototypeDotPropName, functionNode).useSourceInfoIfMissingFromForTree(methodDefinition);
        destinationParent.addChildToFront(definitionStatementNode);
        this.compiler.reportChangeToEnclosingScope(destinationParent);
    }

    private void moveClassInstanceMethodWithStub(String className, Node methodDefinition, Node destinationParent) {
        Preconditions.checkArgument(methodDefinition.isMemberFunctionDef(), methodDefinition);
        Node classMembers = Preconditions.checkNotNull(methodDefinition.getParent());
        Preconditions.checkState(classMembers.isClassMembers(), classMembers);
        Node classNode = classMembers.getParent();
        Preconditions.checkState(classNode.isClass(), classNode);
        int stubId = this.idGenerator.newId();
        Node classNameDotPrototypeDotPropName = this.astFactory.createGetProps(this.astFactory.createName(className, classNode.getJSType()), "prototype", methodDefinition.getString());
        Node stubCall = this.createStubCall(methodDefinition, stubId);
        Node stubDefinitionStatement = this.astFactory.createAssignStatement(classNameDotPrototypeDotPropName, stubCall).useSourceInfoIfMissingFromForTree(methodDefinition);
        Node classDefiningStatement = NodeUtil.getEnclosingStatement(classMembers);
        classDefiningStatement.getParent().addChildAfter(stubDefinitionStatement, classDefiningStatement);
        methodDefinition.detach();
        this.compiler.reportChangeToEnclosingScope(classMembers);
        Node classNameDotPrototypeDotPropName2 = classNameDotPrototypeDotPropName.cloneTree();
        Node functionNode = Preconditions.checkNotNull(methodDefinition.getOnlyChild());
        functionNode.detach();
        Node unstubCall = this.createUnstubCall(functionNode, stubId);
        Node statementNode = this.astFactory.createAssignStatement(classNameDotPrototypeDotPropName2, unstubCall).useSourceInfoIfMissingFromForTree(methodDefinition);
        destinationParent.addChildToFront(statementNode);
        this.compiler.reportChangeToEnclosingScope(destinationParent);
    }

    static boolean hasUnmovableRedeclaration(AnalyzePrototypeProperties.NameInfo nameInfo, AnalyzePrototypeProperties.Property prop) {
        for (AnalyzePrototypeProperties.Symbol symbol : nameInfo.getDeclarations()) {
            AnalyzePrototypeProperties.Property otherProp;
            if (!(symbol instanceof AnalyzePrototypeProperties.Property) || prop == (otherProp = (AnalyzePrototypeProperties.Property)symbol) || prop.getRootVar() != otherProp.getRootVar() || prop.getModule() == otherProp.getModule()) continue;
            return true;
        }
        return false;
    }
}

