/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JsAst;
import com.google.javascript.jscomp.LazyParsedDependencyInfo;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.JsFileParser;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.deps.SimpleDependencyInfo;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticSourceFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompilerInput
extends DependencyInfo.Base
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private JSModule module;
    private final InputId id;
    private final SourceAst ast;
    private DependencyInfo dependencyInfo;
    private final List<DependencyInfo.Require> extraRequires = new ArrayList<DependencyInfo.Require>();
    private final List<String> extraProvides = new ArrayList<String>();
    private final List<DependencyInfo.Require> orderedRequires = new ArrayList<DependencyInfo.Require>();
    private final List<String> dynamicRequires = new ArrayList<String>();
    private boolean hasFullParseDependencyInfo = false;
    private ModuleType jsModuleType = ModuleType.NONE;
    private transient AbstractCompiler compiler;
    private transient ModuleLoader.ModulePath modulePath;

    public CompilerInput(SourceAst ast) {
        this(ast, ast.getSourceFile().getName(), false);
    }

    public CompilerInput(SourceAst ast, boolean isExtern) {
        this(ast, ast.getInputId(), isExtern);
    }

    public CompilerInput(SourceAst ast, String inputId, boolean isExtern) {
        this(ast, new InputId(inputId), isExtern);
    }

    public CompilerInput(SourceAst ast, InputId inputId, boolean isExtern) {
        this.ast = ast;
        this.id = inputId;
        if (isExtern) {
            this.setIsExtern();
        }
    }

    public CompilerInput(SourceFile file) {
        this(file, false);
    }

    public CompilerInput(SourceFile file, boolean isExtern) {
        this(new JsAst(file), isExtern);
    }

    @Override
    public InputId getInputId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.id.getIdName();
    }

    @Override
    public String getPathRelativeToClosureBase() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        Node root = Preconditions.checkNotNull(this.ast.getAstRoot(compiler));
        Preconditions.checkState(root.isScript());
        Preconditions.checkNotNull(root.getInputId());
        return root;
    }

    @Override
    public void clearAst() {
        this.ast.clearAst();
    }

    @Override
    public SourceFile getSourceFile() {
        return this.ast.getSourceFile();
    }

    @Override
    public void setSourceFile(SourceFile file) {
        this.ast.setSourceFile(file);
    }

    public void setCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public ImmutableList<DependencyInfo.Require> getRequires() {
        if (this.hasFullParseDependencyInfo) {
            return ImmutableList.copyOf(this.orderedRequires);
        }
        return this.getDependencyInfo().getRequires();
    }

    @Override
    public ImmutableList<String> getTypeRequires() {
        return this.getDependencyInfo().getTypeRequires();
    }

    ImmutableCollection<DependencyInfo.Require> getKnownRequires() {
        return CompilerInput.concat(this.dependencyInfo != null ? this.dependencyInfo.getRequires() : ImmutableList.of(), this.extraRequires);
    }

    ImmutableList<String> getKnownRequiredSymbols() {
        return DependencyInfo.Require.asSymbolList(this.getKnownRequires());
    }

    @Override
    public ImmutableList<String> getProvides() {
        return this.getDependencyInfo().getProvides();
    }

    @Override
    public boolean getHasExternsAnnotation() {
        return this.getDependencyInfo().getHasExternsAnnotation();
    }

    @Override
    public boolean getHasNoCompileAnnotation() {
        return this.getDependencyInfo().getHasNoCompileAnnotation();
    }

    ImmutableCollection<String> getKnownProvides() {
        return CompilerInput.concat(this.dependencyInfo != null ? this.dependencyInfo.getProvides() : ImmutableList.of(), this.extraProvides);
    }

    public void addProvide(String provide) {
        this.extraProvides.add(provide);
    }

    public boolean addOrderedRequire(DependencyInfo.Require require) {
        if (!this.orderedRequires.contains(require)) {
            this.orderedRequires.add(require);
            return true;
        }
        return false;
    }

    public ImmutableList<String> getDynamicRequires() {
        return ImmutableList.copyOf(this.dynamicRequires);
    }

    public boolean addDynamicRequire(String require) {
        if (!this.dynamicRequires.contains(require)) {
            this.dynamicRequires.add(require);
            return true;
        }
        return false;
    }

    public void setHasFullParseDependencyInfo(boolean hasFullParseDependencyInfo) {
        this.hasFullParseDependencyInfo = hasFullParseDependencyInfo;
    }

    public ModuleType getJsModuleType() {
        return this.jsModuleType;
    }

    public void setJsModuleType(ModuleType moduleType) {
        this.jsModuleType = moduleType;
    }

    public void addRequire(DependencyInfo.Require require) {
        this.extraRequires.add(require);
    }

    DependencyInfo getDependencyInfo() {
        if (this.dependencyInfo == null) {
            this.dependencyInfo = this.generateDependencyInfo();
        }
        if (!this.extraRequires.isEmpty() || !this.extraProvides.isEmpty()) {
            this.dependencyInfo = SimpleDependencyInfo.builder(this.getName(), this.getName()).setProvides(CompilerInput.concat(this.dependencyInfo.getProvides(), this.extraProvides)).setRequires(CompilerInput.concat(this.dependencyInfo.getRequires(), this.extraRequires)).setTypeRequires(this.dependencyInfo.getTypeRequires()).setLoadFlags(this.dependencyInfo.getLoadFlags()).setHasExternsAnnotation(this.dependencyInfo.getHasExternsAnnotation()).setHasNoCompileAnnotation(this.dependencyInfo.getHasNoCompileAnnotation()).build();
            this.extraRequires.clear();
            this.extraProvides.clear();
        }
        return this.dependencyInfo;
    }

    private DependencyInfo generateDependencyInfo() {
        Preconditions.checkNotNull(this.compiler, "Expected setCompiler to be called first: %s", (Object)this);
        Preconditions.checkNotNull(this.compiler.getErrorManager(), "Expected compiler to call an error manager: %s", (Object)this);
        if (this.ast instanceof JsAst && JsFileParser.isSupported()) {
            try {
                DependencyInfo info = new JsFileParser(this.compiler.getErrorManager()).setModuleLoader(this.compiler.getModuleLoader()).setIncludeGoogBase(true).parseFile(this.getName(), this.getName(), this.getCode());
                return new LazyParsedDependencyInfo(info, (JsAst)this.ast, this.compiler);
            }
            catch (IOException e) {
                this.compiler.getErrorManager().report(CheckLevel.ERROR, JSError.make(AbstractCompiler.READ_ERROR, this.getName(), e.getMessage()));
                return SimpleDependencyInfo.EMPTY;
            }
        }
        DepsFinder finder = new DepsFinder(this.getPath());
        Node root = this.getAstRoot(this.compiler);
        if (root == null) {
            return SimpleDependencyInfo.EMPTY;
        }
        finder.visitTree(root);
        JSDocInfo info = root.getJSDocInfo();
        return SimpleDependencyInfo.builder("", "").setProvides(finder.provides).setRequires(finder.requires).setTypeRequires(finder.typeRequires).setLoadFlags(finder.loadFlags).setHasExternsAnnotation(info != null && info.isExterns()).setHasNoCompileAnnotation(info != null && info.isNoCompile()).build();
    }

    public String getCode() throws IOException {
        return this.getSourceFile().getCode();
    }

    public JSModule getModule() {
        return this.module;
    }

    public void setModule(JSModule module) {
        Preconditions.checkArgument(module == null || this.module == null || this.module == module);
        this.module = module;
    }

    void overrideModule(JSModule module) {
        this.module = module;
    }

    public boolean isExtern() {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return false;
        }
        return this.ast.getSourceFile().isExtern();
    }

    void setIsExtern() {
        if (this.ast == null || this.ast.getSourceFile() == null) {
            return;
        }
        this.ast.getSourceFile().setKind(StaticSourceFile.SourceKind.EXTERN);
    }

    public int getLineOffset(int lineno) {
        return this.ast.getSourceFile().getLineOffset(lineno);
    }

    public int getNumLines() {
        return this.ast.getSourceFile().getNumLines();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImmutableMap<String, String> getLoadFlags() {
        return this.getDependencyInfo().getLoadFlags();
    }

    private static <T> ImmutableSet<T> concat(Iterable<T> first, Iterable<T> second) {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(first)).addAll(second)).build();
    }

    public ModuleLoader.ModulePath getPath() {
        if (this.modulePath == null) {
            ModuleLoader moduleLoader = this.compiler.getModuleLoader();
            this.modulePath = moduleLoader.resolve(this.getName());
        }
        return this.modulePath;
    }

    public static enum ModuleType {
        NONE,
        GOOG,
        ES6,
        COMMONJS,
        JSON,
        IMPORTED_SCRIPT;

    }

    private static class DepsFinder {
        private final Map<String, String> loadFlags = new TreeMap<String, String>();
        private final List<String> provides = new ArrayList<String>();
        private final List<DependencyInfo.Require> requires = new ArrayList<DependencyInfo.Require>();
        private final List<String> typeRequires = new ArrayList<String>();
        private final ModuleLoader.ModulePath modulePath;

        DepsFinder(ModuleLoader.ModulePath modulePath) {
            this.modulePath = modulePath;
        }

        void visitTree(Node n) {
            String version;
            this.visitSubtree(n, null);
            Preconditions.checkArgument(n.isScript());
            FeatureSet features = (FeatureSet)n.getProp(Node.FEATURE_SET);
            if (features != null && !(version = features.version()).equals("es3")) {
                this.loadFlags.put("lang", version);
            }
        }

        void visitSubtree(Node n, Node parent) {
            block0 : switch (n.getToken()) {
                case CALL: {
                    if (n.hasTwoChildren() && n.getFirstChild().isGetProp() && n.getFirstFirstChild().matchesQualifiedName("goog")) {
                        if (!this.requires.contains(DependencyInfo.Require.BASE)) {
                            this.requires.add(DependencyInfo.Require.BASE);
                        }
                        Node callee = n.getFirstChild();
                        Node argument = n.getLastChild();
                        switch (callee.getLastChild().getString()) {
                            case "module": {
                                this.loadFlags.put("module", "goog");
                            }
                            case "provide": {
                                if (!argument.isString()) {
                                    return;
                                }
                                this.provides.add(argument.getString());
                                return;
                            }
                            case "require": {
                                if (!argument.isString()) {
                                    return;
                                }
                                this.requires.add(DependencyInfo.Require.googRequireSymbol(argument.getString()));
                                return;
                            }
                            case "requireType": {
                                if (!argument.isString()) {
                                    return;
                                }
                                this.typeRequires.add(argument.getString());
                                return;
                            }
                            case "loadModule": {
                                n = argument.getLastChild();
                                break block0;
                            }
                        }
                        return;
                    }
                    if (!parent.isGetProp() || !parent.matchesQualifiedName("goog.declareModuleId") || !parent.getParent().isCall()) break;
                    Node argument = parent.getParent().getSecondChild();
                    if (!argument.isString()) {
                        return;
                    }
                    this.provides.add(argument.getString());
                    break;
                }
                case MODULE_BODY: {
                    if (parent.getBooleanProp(Node.GOOG_MODULE)) break;
                    this.provides.add(this.modulePath.toModuleName());
                    this.loadFlags.put("module", "es6");
                    break;
                }
                case IMPORT: {
                    this.visitEs6ModuleName(n.getLastChild(), n);
                    return;
                }
                case EXPORT: {
                    if (NodeUtil.isExportFrom(n)) {
                        this.visitEs6ModuleName(n.getLastChild(), n);
                    }
                    return;
                }
                case VAR: {
                    if (!n.getFirstChild().matchesQualifiedName("goog") || !NodeUtil.isNamespaceDecl(n.getFirstChild())) break;
                    this.provides.add("goog");
                    break;
                }
                case EXPR_RESULT: 
                case CONST: 
                case BLOCK: 
                case SCRIPT: 
                case NAME: 
                case DESTRUCTURING_LHS: 
                case LET: {
                    break;
                }
                default: {
                    return;
                }
            }
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                this.visitSubtree(child, n);
            }
        }

        void visitEs6ModuleName(Node n, Node parent) {
            Preconditions.checkArgument(n.isString());
            Preconditions.checkArgument(parent.isExport() || parent.isImport());
            String moduleName = n.getString();
            if (moduleName.startsWith("goog:")) {
                this.requires.add(DependencyInfo.Require.googRequireSymbol(moduleName.substring(5)));
                return;
            }
            ModuleLoader.ModulePath importedModule = this.modulePath.resolveJsModule(moduleName, this.modulePath.toString(), n.getLineno(), n.getCharno());
            if (importedModule == null) {
                importedModule = this.modulePath.resolveModuleAsPath(moduleName);
            }
            this.requires.add(DependencyInfo.Require.es6Import(importedModule.toModuleName(), n.getString()));
        }
    }
}

