/**
 * Copyright © 2017 tesshu.com (webmaster@tesshu.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tesshu.subsonic.client.sample4_music_andmovie;

import com.tesshu.subsonic.client.SuccessObserver;
import com.tesshu.subsonic.client.controller.Search2Controller;
import com.tesshu.subsonic.client.controller.StreamController;
import com.tesshu.subsonic.client.model.Child;
import com.tesshu.subsonic.client.model.SearchResult2;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.client.RestTemplate;

import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;

/**
 * Acquire the stream using format conversion of the server, save the media
 * locally, and then perform the performance immediately after.
 */
@SpringBootApplication
@ComponentScan(basePackages = { "com.tesshu.subsonic.client" })
public class StreamDownloadAndPlayApplication extends Application {

  private static ApplicationContext context;

  private static String             tmpPath    = "target/tmp";

  private String                    format     = "mp3";

  private int                       maxBitRate = 128;

  public static void main(String[] args) {
    context = SpringApplication.run(StreamDownloadAndPlayApplication.class,
        args);
    launch(args);
  }

  @Bean
  public RestTemplate restTemplate(RestTemplateBuilder builder) {
    return builder.build();
  }

  @Override
  public void start(Stage stage) throws Exception {

    Search2Controller search2 = context.getBean(Search2Controller.class);

    StreamController streamController = context.getBean(StreamController.class);

    SuccessObserver callback = context.getBean(SuccessObserver.class);

    File tmpDirectory = new File(tmpPath);
    tmpDirectory.mkdir();

    Optional<SearchResult2> result2 = search2.getOf("e", null, null, null, null,
        1, null, null);

    result2.ifPresent(result -> {
      Optional<Child> maybeSong = result.getSongs().stream().findFirst();
      maybeSong.ifPresent(song -> {

        streamController.stream(song, maxBitRate, format, null, null, null,
            null, (subject, inputStream, contentLength) -> {

              File dir = new File(tmpPath + "/"
                  + song.getPath().replaceAll("([^/]+?)?$", StringUtils.EMPTY));
              dir.mkdirs();

              File file = new File(tmpPath + "/"
                  + song.getPath().replaceAll("([^.]+?)?$", StringUtils.EMPTY)
                  + format);

              try {
                BufferedOutputStream fos = new BufferedOutputStream(
                    new FileOutputStream(file));
                BufferedInputStream reader = new BufferedInputStream(
                    inputStream);

                byte buf[] = new byte[256];
                int len;
                while ((len = reader.read(buf)) != -1) {
                  fos.write(buf, 0, len);
                }
                fos.flush();
                fos.close();
                reader.close();
                inputStream.close();
              } catch (IOException e) {
                e.printStackTrace();
              }

              String path = Paths.get(file.getPath()).toUri().toString();
              Group root = new Group();
              Scene scene = new Scene(root, 640, 480);
              Media media = new Media(path);
              MediaPlayer player = new MediaPlayer(media);
              MediaView view = new MediaView(player);
              ((Group) scene.getRoot()).getChildren().add(view);
              stage.setScene(scene);
              stage.show();

              player.play();

            }, callback);

      });

    });
  }

}
