/**
 * Copyright © 2017 tesshu.com (webmaster@tesshu.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tesshu.subsonic.client.sample4_music_andmovie;

import com.tesshu.subsonic.client.SuccessObserver;
import com.tesshu.subsonic.client.controller.DownloadController;
import com.tesshu.subsonic.client.controller.Search2Controller;
import com.tesshu.subsonic.client.model.SearchResult2;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.client.RestTemplate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;

import javax.annotation.Resource;

/**
 * Retrieve the original format file on the server.
 */
@SpringBootApplication
@ComponentScan(basePackages = { "com.tesshu.subsonic.client" })
public class BinaryDownloadApplication {

  private static final Log   LOG     = LogFactory
      .getLog(new Throwable().getStackTrace()[0].getClassName());

  private static String      tmpPath = "target/tmp";

  @Resource
  private SuccessObserver    callback;

  @Resource
  private DownloadController download;

  @Resource
  private Search2Controller  search2;

  public static void main(String[] args) {
    SpringApplication.run(BinaryDownloadApplication.class);
  }

  @Bean
  public RestTemplate restTemplate(RestTemplateBuilder builder) {
    return builder.build();
  }

  @Bean
  protected CommandLineRunner run(RestTemplate restTemplate) throws Exception {
    return args -> {

      File tmpDirectory = new File(tmpPath);
      tmpDirectory.mkdir();

      Optional<SearchResult2> result2 = search2.getOf("e", null, null, null,
          null, 1, null, null);
      result2.ifPresent(result -> result.getSongs().forEach(song -> {

        download.download(song, (subject, inputStream) -> {

          File dir = new File(tmpPath + "/"
              + song.getPath().replaceAll("([^/]+?)?$", StringUtils.EMPTY));
          dir.mkdirs();
          File file = new File(tmpPath + "/" + song.getPath());
          try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedInputStream reader = new BufferedInputStream(inputStream);
            byte buf[] = new byte[256];
            int len;
            while ((len = reader.read(buf)) != -1) {
              fos.write(buf, 0, len);
            }
            fos.flush();
            fos.close();
            reader.close();
            inputStream.close();
          } catch (IOException e) {
            e.printStackTrace();
          }
          LOG.info(file.getAbsolutePath());
        }, callback);
      }));

      tmpDirectory.deleteOnExit();
    };

  }

}
