/**
 * Copyright © 2017 tesshu.com (webmaster@tesshu.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tesshu.subsonic.client.sample3_create_url;

import com.tesshu.subsonic.client.SuccessObserver;
import com.tesshu.subsonic.client.controller.Search2Controller;
import com.tesshu.subsonic.client.controller.StreamController;
import com.tesshu.subsonic.client.model.Child;
import com.tesshu.subsonic.client.model.MediaType;
import com.tesshu.subsonic.client.model.SearchResult2;
import com.tesshu.subsonic.client.util.IRequestUriObserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.web.client.RestTemplate;

import java.util.Optional;

import javax.annotation.Resource;

/**
 * Confirm connection to the server.
 */
@SpringBootApplication
@ComponentScan(basePackages = { "com.tesshu.subsonic.client" })
public class CreateUrlApplication {

  private static final Log  LOG = LogFactory
      .getLog(new Throwable().getStackTrace()[0].getClassName());

  @Resource
  private Search2Controller search2;

  @Resource
  private StreamController  stream;

  @Resource
  private SuccessObserver   callback;

  public static void main(String[] args) {
    SpringApplication.run(CreateUrlApplication.class);
  }

  @Bean
  public RestTemplate restTemplate(RestTemplateBuilder builder) {
    return builder.build();
  }

  private String movieUrl = null;

  @Bean
  protected CommandLineRunner run(RestTemplate restTemplate) throws Exception {

    return args -> {

      final IRequestUriObserver uriCallBack = (subject, uri) -> {
        movieUrl = uri.toString();
      };

      final String format = "mp4";

      Optional<SearchResult2> result2 = search2.getOf("CORPSE BRIDE", 0, null,
          0, null, 10, null, null);

      result2.ifPresent(r -> {
        Optional<Child> movie = r.getSongs().stream()
            .filter(child -> MediaType.VIDEO == child.getType())
            .filter(child -> format.equals(child.getSuffix())).findFirst();
        movie.ifPresent(m -> {
          stream.stream(m, null, format, null, null, true, false, null,
              uriCallBack);
        });

        LOG.info(movieUrl);

      });
    };
  }

}
