/**
 * Copyright © 2017 tesshu.com (webmaster@tesshu.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.tesshu.subsonic.client;

import static com.tesshu.subsonic.client.model.ResponseStatus.FAILED;
import static org.apache.commons.lang3.StringUtils.join;

import com.tesshu.subsonic.client.domain.IResponseStatusSubject;
import com.tesshu.subsonic.client.domain.IRestService;
import com.tesshu.subsonic.client.model.Error;
import com.tesshu.subsonic.client.model.ResponseStatus;
import com.tesshu.subsonic.client.util.IRequestUriObserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.net.URI;

@Scope("prototype")
@Component
public class SuccessObserver implements IRequestUriObserver {

  private static final Log LOG = LogFactory
      .getLog(new Throwable().getStackTrace()[0].getClassName());

  @Override
  public boolean isConnect() {
    return true;
  }

  @Override
  public void update(IResponseStatusSubject subject, ResponseStatus status,
      Error error, String version) {
    if (FAILED == status) {
      LOG.error(join(subject.getClass(), ", ", status, ", ",
          Integer.toString(error.getCode()), ", ", error.getMessage()));
    }
    LOG.info(join("status :", status.toString()));
  }

  @Override
  public void update(IRestService subject, URI uri) {
    LOG.info(join(subject.getClass(), ":", uri));
  }

}
