
package com.tesshu.subsonic.client;

import com.tesshu.subsonic.client.domain.IEntityService;
import com.tesshu.subsonic.client.model.IEntity;
import com.tesshu.subsonic.client.util.IServiceCustomizer;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Scope("prototype")
@Component
public class ServiceCustomizer implements IServiceCustomizer {

  @Resource
  private SuccessObserver observer;

  @Override
  public void apply(IEntityService<? extends IEntity> service) {
    service.addObserver(observer);
  }

}
