/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class JdbcCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneFieldOrMethod((ClassNode)classNode, (String[])new String[]{"JdbcTemplate", "NamedParameterJdbcTemplate", "DataSource"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.jdbc.core.JdbcTemplate"}).add(new String[]{"spring-boot-starter-jdbc"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports(new String[]{"org.springframework.jdbc.core", "org.springframework.jdbc.core.namedparam"});
        imports.addImports(new String[]{"javax.sql.DataSource"});
    }
}

