/*
 * FileUploadDialog.fx
 *
 * Created on 9-jul-2009, 13:33:13
 */
import java.io.File;
import javax.swing.JFileChooser;

import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.VBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextBox;
import javafx.scene.layout.LayoutInfo;
import javafx.scene.control.Button;
import javafx.data.Pair;

import FileUpload.*;
import java.lang.Exception;

/**
 * @author jgoyvaer
 */

def WIDTH = 400;
def HEIGHT = 160;
def UPLOAD_URL = "http://localhost:8080/.....";

var fileToUpload:File;
var fileNameToUpload:String;
var progressUpload:Float;
var bytesToUpload:Float;

var uploadRequest:HttpRequest;

function start() {
    progressUpload = 0;
    bytesToUpload = 0;
    uploadRequest = HttpRequest {
        location: UPLOAD_URL
        files: [ fileToUpload ]
        fields: [
                  Pair {
                    name: "title"
                    value: "file title"
                  }
                  Pair {
                    name: "notes"
                    value: "file notes"
                  }
                ]
        onToWrite: function( size:Long ) {
            bytesToUpload = size;
        }
        onWritten: function( size:Long ) {
            progressUpload = 1.0 * size / bytesToUpload;
        }
        onDone: stop
        onException: function( ex:Exception ) {
            println(ex.getMessage());
            stop();
        }
    }
    uploadRequest.start();
}

function stop() {
    progressUpload = 0;
    bytesToUpload = 0;
    if ( uploadRequest != null ) {
        uploadRequest.stop();
        uploadRequest = null;
    }
}


Stage {
    title: "Uploading files over HTTP"
    scene: Scene {
        width: WIDTH
        height: HEIGHT
        content: HBox {
            spacing: 5
            content: [
                        ProgressIndicator {
                            progress: bind progressUpload
                            layoutInfo: LayoutInfo {
                                width: 100
                                height: 150
                            }
                            scaleX: 4
                            scaleY: 4
                        }
                        VBox {
                            spacing: 5
                            content: [
                                        Label {
                                            text:"File to upload"
                                        }
                                        HBox {
                                            spacing: 2
                                            content: [
                                                    TextBox {
                                                        text: bind fileNameToUpload with inverse
                                                        layoutInfo: LayoutInfo {
                                                            width: WIDTH - 150;
                                                        }
                                                    }
                                                    Button {
                                                        text:"..."
                                                        action: function() {
                                                            def fc = JFileChooser{};
                                                            if ( fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION ) {
                                                                fileToUpload = fc.getSelectedFile();
                                                                fileNameToUpload = fileToUpload.getAbsolutePath();
                                                            }
                                                        }
                                                    }
                                                ]
                                        }
                                        Button {
                                            text: bind if ( uploadRequest != null ) "Cancel" else "Upload";
                                            disable: bind fileToUpload == null;
                                            action: function() {
                                                if ( uploadRequest != null ) {
                                                    stop();
                                                }
                                                else {
                                                    start();
                                                }
                                            }
                                        }
                                     ]
                        }
                     ]
        }
    }
}